<#ibiztemplate>
TARGET=PSSYSAPP
</#ibiztemplate>
<#assign httpPort = "8080">
<#if sysrun?? >
  <#if sysrun.getPSDevSlnMSDepApp()??>
    <#if sysrun.getPSDevSlnMSDepApp().getHttpPort()??>
      <#assign httpPort = sysrun.getPSDevSlnMSDepApp().getHttpPort()?c>
    </#if>
  </#if>
</#if>
server:
  port: ${httpPort}

<#if item.getAllPSAppDataEntities?? && app.getAllPSAppDataEntities()??>
#zuul网关路由设置
zuul:
  routes:
  <#assign haswfentity=false>
  <#list item.getAllPSAppDataEntities() as appDataEntity>
    <#assign serviceId="">
    <#assign serviceUrl=srfpluralize(appDataEntity.codeName?lower_case)>
    <#assign appEntity=appDataEntity.name?lower_case>
    <#assign psDataEntity=appDataEntity.getPSDataEntity()>
    <#assign systemName=sys.getCodeName()?lower_case>
    <#if psDataEntity.hasPSDEWF()?? && psDataEntity.hasPSDEWF()==true>
        <#assign haswfentity=true>
    </#if>
    <#if psDataEntity.getStorageMode()==4>
        <#comment>serviceApi模式</#comment>
        <#assign serviceId=(psDataEntity.getPSSubSysServiceAPI().getServiceCodeName())!''>
        <#assign serviceUrl=srfpluralize(appDataEntity.name?lower_case)>
    <#else>
        <#assign sysApi=appDataEntity.getPSDEServiceAPI().getPSSysServiceAPI().codeName?lower_case>
        <#assign deApi=appDataEntity.getPSDEServiceAPI().codeName?lower_case>
        <#assign serviceId=systemName+"-"+sysApi>
    </#if>
    <#if serviceId!="">
    ${appEntity}:
      path: /${serviceUrl}/**
      serviceId: ${serviceId}
      stripPrefix: false
    </#if>
  </#list>
  <#if haswfentity==true>
    wfcore:
      path: /wfcore/**
      serviceId: ibzwf-api
      stripPrefix: true
  </#if>
  <#if sys.getPSSystemSetting()?? && sys.getPSSystemSetting().getDataAccCtrlArch()?? && sys.getPSSystemSetting().getDataAccCtrlArch()==1>
    loginv7:
      path: /v7/login
      serviceId: ibzuaa-api
      stripPrefix: false
  </#if>
  <#comment>通过设置该参数，避免Zuul转发请求时丢失Authorization请求头信息</#comment>
  sensitive-headers:
    - Cookie,Set-Cookie,Authorization
</#if>
